/*
 * Copyright (c) 2016, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */  

/**
 * \file    DM8127_uart.h
 *
 * \brief   Defines the module register defines for UART
 *
 * This header file contains the Macros definitions and the
 * register overlay structure for DM8127 UART controller.
 *
 * \author  0043
 *
 * \version 01a,09aug,2010 Created.
 */

#ifndef _DM8127_uart_H_
#define _DM8127_uart_H_

#ifdef __cplusplus
 extern "C" {
#endif

/*
 *====================
 * Includes
 *====================
 */
#include "DM8127s_SoC.h"

/**
@addtogroup DM8127 UART
@{
*/

/*
 *====================
 * Defines
 *====================
 */
#define DM8127_UART0_BASE             (0x48020000u)
/**< Base address of UART 0                                                */
#define DM8127_UART1_BASE             (0x48022000u)
/**< Base address of UART 1                                                */
#define DM8127_UART2_BASE             (0x48024000u)
/**< Base address of UART 2                                                */
#define DM8127_UART3_BASE             (0x481A6000u)
/**< Base address of UART 3                                                */
#define DM8127_UART4_BASE             (0x481A8000u)
/**< Base address of UART 4                                                */
#define DM8127_UART5_BASE             (0x481AA000u)
/**< Base address of UART 5                                                */

#define RHR_OFFSET                     0x0  
/**< Receive Hold register - Read only register                            */
#define THR_OFFSET                     0x0  
/**< Transmit Hold register - Write only register						   */
#define IER_OFFSET                     0x4  
/**< Interrupt Enable Register - To Access: EFR[4]=1					   */
#define IIR_OFFSET                     0x8  
/**< Interrupt Identification register - Read only register				   */
#define FCR_OFFSET                     0x8  
/**< FIFO Control Registger - Write only register - To access: EFR[4] = 1  */
#define LCR_OFFSET                     0xc
/**< Line Control Registger                     						   */
#define MCR_OFFSET                     0x10 
/**< Mode Control - To Access: EFR[4] = 1	     						   */
#define LSR_OFFSET                     0x14 
/**< Line Status register - Read only register						       */
#define MSR_OFFSET                     0x18 
/**< Modem Status register - Read only register						       */
#define TCR_OFFSET                     0x18 
/**< Transmission Control register - To Access: EFR[4] = 1 & MCR[6] = 1    */
#define TLR_OFFSET                     0x1c 
/**< Trigger Level register - To Access: EFR[4]=1 & MCR[6]=1               */
#define SPR_OFFSET                     0x1c
/**< Scratch Pad register                   						       */
#define MDR1_OFFSET                    0x20
/**< Mode Definition register 1											   */
#define MDR2_OFFSET                    0x24
/**< Mode Definition register 2											   */
#define SFLSR_OFFSET                   0x28 
/**< Status FIFO Line Status Register - Read Only register 				   */
#define TXFLL_OFFSET                   0x28 
/**< Transmit Frame Length Low Register - Wite Only register 			   */
#define RESUME_OFFSET                  0x2c 
/**< Status FIFO Line Status Register - Read Only register 				   */
#define TXFLH_OFFSET                   0x2c 
/**< Transmit Frame Length High Register - Wite Only register 			   */
#define SFREGL_OFFSET                  0x30 
/**< Status FIFO Low Register - Wite Only register 			               */
#define RXFLL_OFFSET                   0x30 
/**< Receive Frame Length Low Register - Wite Only register 			   */
#define SFREGH_OFFSET                  0x34 
/**< Status FIFO High Register - Wite Only register 			           */
#define RXFLH_OFFSET                   0x34 
/**< Receive Frame Length high Register - Wite Only register 			   */
#define BLR_OFFSET                     0x38
/**< BOF Control Register   								 			   */
#define ACREG_OFFSET                   0x3c
/**< Auxiliary Control Register   								 		   */
#define SCR_OFFSET                     0x40
/**< Supplementary  Control Register   								 	   */
#define SSR_OFFSET                     0x44 
/**< Supplementary  Status Register   								 	   */
#define EBLR_OFFSET                    0x48
/**< BOF Length Register   								 	               */
#define MVR_OFFSET                     0x50 // Read only
/**< Module version Register   								 	           */
#define SYSC_OFFSET                    0x54
/**< System Configuration Register   								 	   */
#define SYSS_OFFSET                    0x58
/**< System Status Register   								 	           */
#define WER_OFFSET                     0x5C
/**< Wake-up Enable Register   								 	           */
#define CFPS_OFFSET                    0x60
/**< Carrier Frequency Pre-scaller Register   							   */
#define RXFIFO_LVL_OFFSET              0x64
/**< Receive FIFO level Register   							               */
#define TXFIFO_LVL_OFFSET              0x68
/**< Transmit FIFO Level Register   							           */
#define IER2_OFFSET              	   0x6C
/**< Interrupt Enable 2 Register   							               */
#define ISR2_OFFSET              	   0x70
/**< Interrupt Status 2 Register   							               */

/* ------------------------------------------------------------------------ *
 *  Control Registers for: UART Registers minus Base Address (  )           *
 *  These Registers are available with "LCR[bit 7] = 1"                     *
 * ------------------------------------------------------------------------ */
#define USE_LCR_80              ( 0x100 )
#define DLL                     ( USE_LCR_80 + 0x0 )
#define DLH                     ( USE_LCR_80 + 0x4 )
#define UASR                    ( USE_LCR_80 + 0x38 )

/* ------------------------------------------------------------------------ *
 *  Control Registers for: UART Registers minus Base Address (  )           *
 * These Registers are available with "LCR = 0xBF"                          *
 * ------------------------------------------------------------------------ */
#define USE_LCR_BF              ( 0x200 )
#define EFR                     ( USE_LCR_BF + 0x8 )
#define XON1                    ( USE_LCR_BF + 0x10 )
#define XON2                    ( USE_LCR_BF + 0x14 )
#define XOFF1                   ( USE_LCR_BF + 0x18 )
#define XOFF2                   ( USE_LCR_BF + 0x1c )


/* @} */   /* End of UART */

#ifdef __cplusplus
} /* End of extern C */
#endif /* #ifdef __cplusplus */

#endif  /* End of _DM8127_uart_H_ */
